﻿using VA.TMP.Integration.VIMT.Messages.VideoVisit;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Update
{
    public class CreateResponseStep : FilterBase<VideoVisitUpdateStateObject>
    {
        public override void Execute(VideoVisitUpdateStateObject state)
        {
            {
                if (!string.IsNullOrEmpty(state.FakeResponseType))
                {
                    var fakeEcResponse = VistaSchedulingUtilities.CreateFakeBookResult(state.FakeResponseType, state);
                    state.VideoVisitUpdateResponseMessage = new VideoVisitUpdateResponseMessage
                    {
                        ExceptionMessage = "*****THIS IS FAKE DATA. DATA NOT SENT TO VVS*****",
                        ExceptionOccured = false,
                        SerializedInstance = state.SerializedAppointment,
                        WriteResults = VistaSchedulingUtilities.MapEcToWriteResult(fakeEcResponse)
                    };
                }
                else
                {
                    state.VideoVisitUpdateResponseMessage = state.ExceptionOccured
                        ? new VideoVisitUpdateResponseMessage
                        {
                            ExceptionOccured = true,
                            ExceptionMessage = state.ExceptionMessage,
                            SerializedInstance = state.SerializedAppointment
                        }
                        : new VideoVisitUpdateResponseMessage
                        {
                            ExceptionMessage = string.Empty,
                            ExceptionOccured = false,
                            SerializedInstance = state.SerializedAppointment,
                            WriteResults = VistaSchedulingUtilities.MapEcToWriteResult(state.EcResponse.VIMTTmpUpdateAppointmentResponseDataInfo.VIMTTmpWriteResults)
                        };
                }
            }
        }
    }
}